package com.mulesoft.mule.module.datamapper.clover;

import java.lang.reflect.Field;

import org.jetel.graph.Node;

/**
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
public enum MappingFormat
{
    CSV(true)
            {
                @Override
                public String getReaderType()
                {
                    return "DATA_READER";
                }

                @Override
                public String getWriterType()
                {
                    return "DATA_WRITER";
                }

                @Override
                public String getContentType()
                {
                    return "application/CSV";
                }

                @Override
                public String getEncoding(Node node)
                {
                    return (String) getFieldValue(node, node.getClass(), getEncodingField());
                }
            },
    XML(true)
            {
                @Override
                public String getReaderType()
                {
                    return "XML_READER";
                }

                @Override
                public String getWriterType()
                {
                    return "EXT_XML_WRITER";
                }

                public String getContentType()
                {
                    return "application/xml";
                }

                @Override
                public String getEncoding(Node node)
                {
                    return (String) getFieldValue(node, node.getClass().getSuperclass(), getEncodingField());
                }


            },
    JAVA(false)
            {
                @Override
                public String getReaderType()
                {

                    return "BEAN_READER";
                }

                @Override
                public String getWriterType()
                {

                    return "BEAN_WRITER";
                }

                public String getContentType()
                {
                    return null;
                }

                @Override
                public String getEncoding(Node node)
                {
                    return null;
                }


            },
    JSON(true)
            {
                @Override
                public String getReaderType()
                {
                    return "JSON_READER";
                }

                @Override
                public String getWriterType()
                {
                    return "JSON_WRITER";
                }

                public String getContentType()
                {
                    return "application/json";
                }

                @Override
                public String getEncoding(Node node)
                {
                    return (String) getFieldValue(node, node.getClass().getSuperclass(), getEncodingField());
                }


            },

    MAP(false)
            {
                @Override
                public String getReaderType()
                {

                    return "BEAN_READER";
                }

                @Override
                public String getWriterType()
                {

                    return "MAP_WRITER";
                }

                public String getContentType()
                {
                    return null;
                }

                @Override
                public String getEncoding(Node node)
                {
                    return null;
                }


            },
    XLS(true)
            {
                @Override
                public String getReaderType()
                {
                    return "SPREADSHEET_READER";

                }

                @Override
                public String getWriterType()
                {
                    return "SPREADSHEET_WRITER";
                }

                public String getContentType()
                {
                    return "application/vnd.ms-excel";
                }

                @Override
                public String getEncoding(Node node)
                {
                    return null;
                }


            };

    private boolean fileBased;

    private MappingFormat(boolean textBased)
    {
        this.fileBased = textBased;
    }

    public abstract String getReaderType();

    public abstract String getWriterType();

    public abstract String getContentType();

    public abstract String getEncoding(Node node);

    protected Object getFieldValue(Object value, Class fieldOwner, String fieldName)
    {
        Field declaredField;
        try
        {
            declaredField = fieldOwner.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return declaredField.get(value);
        }
        catch (NoSuchFieldException e)
        {

        }
        catch (IllegalAccessException e)
        {

        }

        return null;
    }

    public String getEncodingField()
    {
        return "charset";
    }

    public boolean isFileBased()
    {
        return fileBased;
    }


}
