/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import com.mulesoft.mule.module.datamapper.clover.impl.GraphRuntimeContextFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.FilePathGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.InputStreamCloverGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CreateDestroyGraphProvider;

import java.io.InputStream;

import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.ExecutionType;

public class SimpleCloverGraphExecutorFactoryImpl extends AbstractCloverGraphExecutorFactory
{

    private String id;

    public SimpleCloverGraphExecutorFactoryImpl(String id, CloverEngineManager cloverEngineManager)
    {
        super(cloverEngineManager);

        this.id = id;
    }


    @Override
    protected CloverEngineImpl getCloverEngine()
    {
        return getCloverEngineManager().getCloverEngine(id);
    }

    @Override
    protected GraphProvider<TransformationGraph> createGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException
    {
        return CreateDestroyGraphProvider.createGraphProvider(graphFactory);
    }

    @Override
    protected CloverGraphFactory createGraphFactory(String transformationGraphPath, ExecutionType executionType)
    {
        return new FilePathGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType), transformationGraphPath);
    }

    @Override
    protected CloverGraphFactory createGraphFactory(InputStream inputStream, ExecutionType executionType)
    {
        return new InputStreamCloverGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType), inputStream);
    }


    @Override
    public void dispose()
    {
        getCloverEngineManager().dispose(id);
    }
}
