/**
 *
 * (c) 2013 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;

import org.jetel.graph.runtime.WatchDog;

public class CloverEngineHandler implements  FutureCallback<TransformationResult>
{

    private WatchDog watchDog;
    private volatile boolean done;


    public CloverEngineHandler(WatchDog watchDog)
    {
        this.watchDog = watchDog;
        this.setDone(false);
    }


    @Override
    public void done(TransformationResult result)
    {
        setDone(true);
    }

    @Override
    public void failed(Throwable throwable)
    {
        setDone(true);
    }

    @Override
    public void cancelled()
    {
        setDone(true);
    }

    private void setDone(boolean done)
    {
        if (this.done != done)
        {
            this.done = done;
        }
    }
}
