/**
 *
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import org.jetel.plugin.PluginLocation;
import org.mule.api.MuleContext;

import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import org.jetel.graph.runtime.EngineInitializer;
import org.mule.module.launcher.FineGrainedControlClassLoader;

public class CloverEngineManager {

    private final ConcurrentHashMap<String, CloverEngineImpl> engineByApp;
    private Lock accessLock = new ReentrantLock();


    public CloverEngineManager(CloverEngineConfig cloverEngineConfig, ConcurrentHashMap<String, CloverEngineImpl> map) {
        this.engineByApp = map;

        initPlugins(cloverEngineConfig);
    }

    private void initPlugins(CloverEngineConfig cloverEngineConfig) {
        final FineGrainedControlClassLoader controlClassLoader = generateFilteredClassLoader();

        final String[] cloverPluginDirPaths = cloverEngineConfig.getCloverPluginDirPath().split(CloverEngineConfig.PATH_SEPARATOR);
        final HashSet<String> uniquePaths = new HashSet<String>(Arrays.asList(cloverPluginDirPaths));
        final List<PluginLocation> plugins = new ArrayList<PluginLocation>();
        try {
            for (String cloverPluginDirPath : uniquePaths) {
                File file = new File(cloverPluginDirPath);
                File[] children = file.listFiles();
                for (File child : children) {
                    PluginLocation pluginLocation = new PluginLocation(child.toURI().toURL(), controlClassLoader);
                    plugins.add(pluginLocation);
                }
            }


            EngineInitializer.initEngine(plugins.toArray(new PluginLocation[plugins.size()]), null, null);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }

    }


    private FineGrainedControlClassLoader generateFilteredClassLoader() {
        return new FineGrainedControlClassLoader(new URL[0], this.getClass().getClassLoader(), new HashSet<String>(getFilteredPackages()));
    }

    /**
     * List of packages that needs to be filtered since mule conflicts with clover
     * @return The list of packages
     */
    private List<String> getFilteredPackages() {
        return Arrays.asList("-net.sf.saxon","-org.apache.commons.beanutils");
    }


    public CloverEngineImpl getCloverEngine(MuleContext context) {
        String id = context.getConfiguration().getId();
        return getCloverEngine(id);
    }

    public CloverEngineImpl getCloverEngine(String id) {
        if (!engineByApp.contains(id)) {
            engineByApp.putIfAbsent(id, new CloverEngineImpl());
        }

        return engineByApp.get(id);
    }

    public void dispose(MuleContext muleContext) {
        String id = muleContext.getConfiguration().getId();
        dispose(id);
    }

    public void dispose(String id) {
        try {
            accessLock.lock();
            if (engineByApp.contains(id)) {
                engineByApp.get(id).dispose();
                engineByApp.remove(id);
            }
        } finally {
            accessLock.unlock();
        }
    }
}
