package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Singleton provider of CloverEngineManager
 */
public enum CloverEngineManagerContainer
{

    INSTANCE;

    private CloverEngineManager cloverEngineManager;

    CloverEngineManagerContainer() {

    }

    public CloverEngineManager getCloverEngineManager()
    {
        if(cloverEngineManager == null){
            cloverEngineManager = new CloverEngineManager(CloverEngineConfig.createDefault(), new ConcurrentHashMap<String, CloverEngineImpl>());
        }
        return cloverEngineManager;
    }
}
