/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.Status;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;
import com.mulesoft.mule.module.datamapper.impl.DefaultGraphExecutor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jetel.graph.Result;
import org.jetel.graph.dictionary.Dictionary;


public class CloverResult implements TransformationResult
{
    private Result result;
    private Map<String, Object> outputArguments;
    private Object payload;
    private Throwable causeException;

    public CloverResult(Result result, Dictionary dictionary)
    {
        this.result = result;
        this.outputArguments = new HashMap<String, Object>();

        loadDataFromDictionary(dictionary);

    }

    private void loadDataFromDictionary(Dictionary dictionary)
    {
        Set<String> keys = dictionary.getKeys();
        for (String key : keys)
        {
            if (dictionary.isOutput(key) && !key.equals(DefaultGraphExecutor.MULE_OUTPUT_PAYLOAD_KEY))
            {
                this.outputArguments.put(key, dictionary.getValue(key));
            }
        }

        Object value = dictionary.getValue(DefaultGraphExecutor.MULE_OUTPUT_PAYLOAD_KEY);
        if (value instanceof List)
        {
            List resultList = (List) value;
            if (resultList.size() == 1)
            {
                payload = resultList.get(0);
            }
        }
        else
        {
            payload = value;
        }
    }

    @Override
    public Status getStatus()
    {
        Status status = Status.READY;
        switch (result)
        {
            case FINISHED_OK:
                status = Status.OK;
                break;
            case ERROR:
                status = Status.ERROR;
                break;
            case RUNNING:
                status = Status.RUNNING;
                break;
            case ABORTED:
                status = Status.ABORTED;
                break;
            case READY:
                status = Status.READY;
                break;
            //todo mariano review other states meaning
//            default:
//                throw new IllegalArgumentException("Status " + result.toString() + " is not supported.");
        }
        return status;
    }

    @Override
    public String getMessage()
    {
        return result.message();
    }

    @Override
    public Object getPayload()
    {
        return payload;
    }


    public Map<String, Object> getOutputArguments()
    {
        return outputArguments;
    }

    public void setCauseException(Throwable causeException)
    {
        this.causeException = causeException;
    }

    public Throwable getCauseException()
    {
        return causeException;
    }
}
