/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

/**
 * Future task capable of notification upon task completion.
 *
 * @param <V>
 * @author jan.michalica
 */
public class NotifyingFutureTask<V> extends FutureTask<V>
{

    private final FutureCallback<V> callback;

    public NotifyingFutureTask(Callable<V> callable, FutureCallback<V> callback)
    {
        super(callable);
        this.callback = callback;
        if (callback == null)
        {
            throw new NullPointerException("Callback cannot be null.");
        }
    }

    public NotifyingFutureTask(Runnable runnable, FutureCallback<V> callback)
    {
        super(runnable, null);
        this.callback = callback;
        if (callback == null)
        {
            throw new NullPointerException("Callback cannot be null.");
        }
    }

    @Override
    protected void done()
    {

        if (isCancelled())
        {
            callback.cancelled();
        }
        else
        {
            try
            {
                callback.done(get());
            }
            catch (CancellationException e)
            {
                callback.cancelled();
            }
            catch (ExecutionException e)
            {
                callback.failed(e.getCause());
            }
            catch (Exception e)
            {
                callback.failed(e);
            }
        }
    }
}
