/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import com.mulesoft.mule.module.datamapper.DataMapperModule;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;

import java.io.InputStream;

import org.jetel.exception.ComponentNotReadyException;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.TransformationGraphXMLReaderWriter;
import org.jetel.graph.dictionary.Dictionary;
import org.jetel.graph.dictionary.ObjectDictionaryType;
import org.jetel.graph.runtime.EngineInitializer;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.w3c.dom.Document;

public abstract class AbstractGraphFactory implements CloverGraphFactory
{

    private GraphRuntimeContextFactory runtimeContextFactory;

    public AbstractGraphFactory(GraphRuntimeContextFactory runtimeContextFactory)
    {
        this.setRuntimeContextFactory(runtimeContextFactory);
    }


    protected TransformationGraph doCreateTransformationGraph(InputStream graphSourceStream,
                                                              GraphRuntimeContext context)
            throws DataMapperCreationException
    {
        try
        {
            final TransformationGraph graph = TransformationGraphXMLReaderWriter.loadGraph(graphSourceStream,
                                                                                           context);
            initGraph(context, graph);
            return graph;
        }
        catch (Exception e)
        {
            throw new DataMapperCreationException(e);
        }
    }

    protected void initGraph(GraphRuntimeContext context, TransformationGraph graph) throws ComponentNotReadyException
    {
        Dictionary dictionary = graph.getDictionary();
        dictionary.setValue(DataMapperModule.MULE_EVENT, ObjectDictionaryType.TYPE_ID, null);
        dictionary.setAsInput(DataMapperModule.MULE_EVENT);

        dictionary.setValue(DataMapperModule.MULE_CONTEXT, ObjectDictionaryType.TYPE_ID, null);
        dictionary.setAsInput(DataMapperModule.MULE_CONTEXT);

        EngineInitializer.initGraph(graph, context);
    }

    public TransformationGraph createTransformationGraph(InputStream graphSourceStream)
            throws DataMapperCreationException
    {
        GraphRuntimeContext graphRuntimeContext = getRuntimeContextFactory().createGraphRuntimeContext();
        return doCreateTransformationGraph(graphSourceStream, graphRuntimeContext);
    }

    public GraphRuntimeContextFactory getRuntimeContextFactory()
    {
        return runtimeContextFactory;
    }

    public void setRuntimeContextFactory(GraphRuntimeContextFactory runtimeContextFactory)
    {
        this.runtimeContextFactory = runtimeContextFactory;
    }
}
