/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.GraphRuntimeContext;


public class AppHomeCloverGraphFactoryImpl extends AbstractGraphFactory
{

    private static Log logger = LogFactory.getLog(AppHomeCloverGraphFactoryImpl.class);

    private final String graph;
    private MuleContext muleContext;


    public AppHomeCloverGraphFactoryImpl(String graph, MuleContext muleContext, GraphRuntimeContextFactory runtimeContextFactory)
    {
        super(runtimeContextFactory);
        this.graph = graph;
        this.muleContext = muleContext;
    }


    public TransformationGraph createTransformationGraph() throws DataMapperCreationException
    {
        String appHome = muleContext.getRegistry().get(MuleProperties.APP_HOME_DIRECTORY_PROPERTY);
        File graphFile = new File(appHome, graph);
        if (!graphFile.exists())
        {
            return new ClasspathCloverGraphFactoryImpl(getRuntimeContextFactory(), graph).createTransformationGraph();
        }
        GraphRuntimeContext graphRuntimeContext = getRuntimeContextFactory().createGraphRuntimeContext();
        FileInputStream fis = null;
        try
        {
            graphRuntimeContext.setContextURL(new File(appHome).toURI().toURL());
            fis = new FileInputStream(graphFile);
            return doCreateTransformationGraph(fis, graphRuntimeContext);
        }
        catch (FileNotFoundException e)
        {
            throw new DataMapperCreationException(e);
        }
        catch (MalformedURLException e)
        {
            throw new DataMapperCreationException(e);
        }
        finally
        {
            try
            {
                if (fis != null)
                {
                    fis.close();
                }
            }
            catch (IOException e)
            {
                logger.error("Exception while closing stream");
            }
        }
    }
}
