/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import org.mule.util.IOUtils;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.GraphRuntimeContext;

public class ClasspathCloverGraphFactoryImpl extends AbstractGraphFactory
{

    private static Log logger = LogFactory.getLog(ClasspathCloverGraphFactoryImpl.class);
    private final String graph;


    public ClasspathCloverGraphFactoryImpl(GraphRuntimeContextFactory runtimeContextFactory, String graph)
    {
        super(runtimeContextFactory);
        this.graph = graph;

    }


    public TransformationGraph createTransformationGraph() throws DataMapperCreationException
    {
        InputStream in = null;
        try
        {
            final URL graphURL = IOUtils.getResourceAsUrl(graph, getClass());
            if (graphURL == null)
            {
                throw new DataMapperCreationException("The data mapping graph " + graph + " does not exists");
            }
            final GraphRuntimeContext graphRuntimeContext = this.getRuntimeContextFactory().createGraphRuntimeContext();
            final File file = new File(graphURL.getFile()).getParentFile();
            graphRuntimeContext.setContextURL(file.toURI().toURL());
            in = graphURL.openStream();
            return doCreateTransformationGraph(in, graphRuntimeContext);
        }
        catch (IOException e)
        {
            logger.error("Unexpected error", e);
            throw new DataMapperCreationException(e);
        }
        finally
        {
            if (in != null)
            {
                try
                {
                    in.close();
                }
                catch (IOException e)
                {
                    logger.error("Unexpected error", e);
                }
            }
        }

    }

}
