package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;


import java.util.Collection;
import java.util.Properties;

import org.jetel.graph.TransformationGraph;
import org.jetel.graph.TransformationGraphXMLReaderWriter;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.support.PropertiesLoaderSupport;
import org.springframework.util.PropertyPlaceholderHelper;
import org.w3c.dom.Document;


public class DocumentCloverGraphFactoryImpl extends AbstractGraphFactory
{

    public static final String APP_HOME = "app_home";
    private MuleContext muleContext;
    private Document document;

    public DocumentCloverGraphFactoryImpl(GraphRuntimeContextFactory runtimeContextFactory, MuleContext muleContext, Document document)
    {
        super(runtimeContextFactory);
        this.muleContext = muleContext;
        this.document = document;

    }

    public TransformationGraph createTransformationGraph() throws DataMapperCreationException
    {
        try
        {
            Object value = muleContext.getRegistry().get(MuleProperties.APP_HOME_DIRECTORY_PROPERTY);
            final Properties properties = new Properties();
            if (value != null)
            {
                properties.put(APP_HOME, value);
            }
            final GraphRuntimeContext graphRuntimeContext = getRuntimeContextFactory().createGraphRuntimeContext(properties);
            final TransformationGraph graph;
            synchronized (this)
            {
                //Only one at a time should parse the document.
                graph = new TransformationGraphXMLReaderWriter(graphRuntimeContext).read(document);
            }
            initGraph(graphRuntimeContext, graph);
            return graph;
        }
        catch (Exception e)
        {
            throw new DataMapperCreationException(e);
        }
    }


}
