/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.GraphRuntimeContext;

public class FilePathGraphFactoryImpl extends AbstractGraphFactory
{

    private final String graph;

    public FilePathGraphFactoryImpl(GraphRuntimeContextFactory runtimeContextFactory, String graph)
    {
        super(runtimeContextFactory);
        this.graph = graph;
    }

    @Override
    public TransformationGraph createTransformationGraph() throws DataMapperCreationException
    {
        try
        {
            return createTransformationGraph(new FileInputStream(graph));
        }
        catch (FileNotFoundException e)
        {
            throw new DataMapperCreationException(e);
        }
    }

}
