/**
 *
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class CloverEventFilter implements EventFilter
{

    public static final String METADATA = "Metadata";
    public static final String REFERENCE_COUNTER = "__referenceCounter";
    private QName filteringElement = null;

    @Override
    public boolean accept(XMLEvent xmlEvent)
    {

        if (xmlEvent.isStartElement())
        {
            StartElement startElement = xmlEvent.asStartElement();
            QName name = startElement.getName();

            if (name.getLocalPart().equalsIgnoreCase(METADATA))
            {
                Attribute referenceCounter = startElement.getAttributeByName(new QName(REFERENCE_COUNTER));
                if (referenceCounter != null && Integer.parseInt(referenceCounter.getValue()) == 0)
                {
                    //If no one use it then do not include the metadata
                    filteringElement = name;
                    return false;
                }
            }
        }

        if (xmlEvent.isEndElement() && filteringElement != null)
        {
            QName name = xmlEvent.asEndElement().getName();
            if (name.equals(filteringElement))
            {
                filteringElement = null;
                return false;
            }

        }
        return filteringElement == null;
    }
}
