/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;

import java.util.Set;

import org.apache.commons.pool.PoolableObjectFactory;
import org.jetel.graph.TransformationGraph;

public class CloverGraphPoolFactory implements PoolableObjectFactory
{

    protected CloverGraphFactory graphFactory;

    public CloverGraphPoolFactory(CloverGraphFactory graphFactory)
    {
        this.graphFactory = graphFactory;
    }


    protected TransformationGraph createTransformationGraph()
            throws DataMapperCreationException
    {
        return getGraphFactory().createTransformationGraph();
    }

    @Override
    public void passivateObject(Object obj) throws Exception
    {

        TransformationGraph graph = (TransformationGraph) obj;
        Set<String> keys = graph.getDictionary().getKeys();
        for (String key : keys)
        {
            graph.getDictionary().setValue(key, null);
        }
        graph.postExecute();

    }

    @Override
    public void destroyObject(Object obj) throws Exception
    {

        TransformationGraph graph = (TransformationGraph) obj;
        graph.free();
    }

    @Override
    public void activateObject(Object obj) throws Exception
    {
        TransformationGraph graph = (TransformationGraph) obj;
        graph.preExecute();
    }

    @Override
    public boolean validateObject(Object obj)
    {
        if (obj == null)
        {
            return false;
        }
        TransformationGraph graph = (TransformationGraph) obj;
        return graph.isInitialized() && graph.isChecked();

    }

    @Override
    public Object makeObject() throws Exception
    {
        return createTransformationGraph();
    }

    public CloverGraphFactory getGraphFactory()
    {
        return graphFactory;
    }

    public void setGraphFactory(CloverGraphFactory graphFactory)
    {
        this.graphFactory = graphFactory;
    }
}
