/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.api.GraphProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;

/**
 * GraphProvider that creates a new graph each time takeGraph is called and frees it
 * when releaseGraph is invoked.
 *
 * @author apose
 */
public class CreateDestroyGraphProvider implements GraphProvider<TransformationGraph>
{

    private static Log logger = LogFactory.getLog(CreateDestroyGraphProvider.class);

    private CloverGraphFactory graphFactory;


    public static CreateDestroyGraphProvider createGraphProvider(CloverGraphFactory graphFactory)
    {
        return new CreateDestroyGraphProvider(graphFactory);
    }

    private CreateDestroyGraphProvider(CloverGraphFactory graphFactory)
    {

        this.graphFactory = graphFactory;
    }

    @Override
    public TransformationGraph takeGraph()
    {
        try
        {
            TransformationGraph graph = newTransformationGraph();
            graph.preExecute();
            graph.init();
            return graph;
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    private TransformationGraph newTransformationGraph()
    {

        try
        {
            return graphFactory.createTransformationGraph();
        }
        catch (DataMapperCreationException e)
        {
            throw new RuntimeException(e);
        }

    }

    @Override
    public void releaseGraph(TransformationGraph transformationGraph)
    {
        try
        {
            transformationGraph.postExecute();
            transformationGraph.free();
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateObject(TransformationGraph transformationGraph)
    {
        releaseGraph(transformationGraph);
    }
}
