/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;

import java.io.IOException;

import org.apache.commons.pool.impl.GenericObjectPool;
import org.jetel.graph.TransformationGraph;

public class PoolGraphProvider implements GraphProvider<TransformationGraph>
{

    public static final int DEFAULT_CACHE_SIZE = Integer.MAX_VALUE;
    private GenericObjectPool pool;

    public static PoolGraphProvider createGraphProvider(CloverGraphPoolFactory graphPoolFactory)
    {
        try
        {
            int defaultMaxGraph = CloverEngineImpl.DEFAULT_MAX_GRAPH <= 0 ? DEFAULT_CACHE_SIZE : CloverEngineImpl.DEFAULT_MAX_GRAPH;
            GenericObjectPool genericObjectPool = new GenericObjectPool(graphPoolFactory, defaultMaxGraph);
            return new PoolGraphProvider(genericObjectPool);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }


    private PoolGraphProvider(GenericObjectPool pool)
            throws IOException, DataMapperCreationException
    {
        this.pool = pool;
    }

    public void initialize(int initialElements)
    {
        for (int i = 0; i < initialElements; i++)
        {
            try
            {
                pool.addObject();
            }
            catch (Exception e)
            {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void releaseGraph(TransformationGraph transformationGraph)
    {
        if(transformationGraph == null)
        {
            return;
        }

        try
        {
            pool.returnObject(transformationGraph);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }

    }

    @Override
    public void invalidateObject(TransformationGraph transformationGraph)
    {
        if(transformationGraph == null)
        {
            return;
        }

        try
        {
            pool.invalidateObject(transformationGraph);
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }

    }

    @Override
    public TransformationGraph takeGraph()
    {
        try
        {
            return (TransformationGraph) pool.borrowObject();
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

}
