/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.api.GraphProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;

public class RecycleSingleGraphProvider implements GraphProvider<TransformationGraph>
{

    private static Log logger = LogFactory.getLog(RecycleSingleGraphProvider.class);

    private TransformationGraph transformationGraph;

    private CloverGraphFactory graphFactory;

    public static RecycleSingleGraphProvider createGraphProvider(CloverGraphFactory cloverGraphFactory) throws DataMapperCreationException
    {
        return new RecycleSingleGraphProvider(cloverGraphFactory);
    }

    private RecycleSingleGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException
    {

        this.graphFactory = graphFactory;
        this.transformationGraph = newTransformationGraph();
    }

    @Override
    public TransformationGraph takeGraph()
    {

        if (!transformationGraph.isInitialized())
        {
            try
            {
                transformationGraph.init();
            }
            catch (Exception e)
            {
                throw new RuntimeException(e);
            }
        }
        return transformationGraph;
    }

    private TransformationGraph newTransformationGraph() throws DataMapperCreationException
    {
        return graphFactory.createTransformationGraph();
    }

    @Override
    public void releaseGraph(TransformationGraph transformationGraph)
    {
        try
        {
            transformationGraph.postExecute();
            transformationGraph.preExecute();
        }
        catch (Exception e)
        {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateObject(TransformationGraph transformationGraph)
    {
        transformationGraph.free();
        takeGraph();
    }
}
