package com.mulesoft.mule.module.datamapper.config;

import org.mule.config.spring.parsers.generic.ChildDefinitionParser;

import com.mulesoft.mule.module.datamapper.processors.DataMapperMessageProcessor;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DataMapperDefinitionParser
        extends ChildDefinitionParser
{

    public static final String INPUT_ARGUMENTS = "inputArguments";
    public static final String INPUT_ARGUMENTS_TAG_NAME = "input-arguments";
    public static final String INPUT_ARGUMENT_TAG_NAME = "input-argument";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String INPUT_REF_ATTR_NAME = "input-ref";

    public DataMapperDefinitionParser()
    {
        super("messageProcessor", DataMapperMessageProcessor.class);

    }

    @Override
    protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder)
    {
        super.parseChild(element, parserContext, builder);

        final Element inputArgumentsListElement = DomUtils.getChildElementByTagName(element, INPUT_ARGUMENTS_TAG_NAME);

        //Handle input-ref can support a reference to a bean at the registry or any mule expression
        if ((element.getAttribute(INPUT_REF_ATTR_NAME) != null) && (!StringUtils.isBlank(element.getAttribute(INPUT_REF_ATTR_NAME))))
        {
            if (element.getAttribute(INPUT_REF_ATTR_NAME).startsWith("#"))
            {
                builder.addPropertyValue("input", element.getAttribute(INPUT_REF_ATTR_NAME));
            }
            else
            {
                builder.addPropertyValue("input", (("#[registry:" + element.getAttribute(INPUT_REF_ATTR_NAME)) + "]"));
            }
        }

        List<Element> inputArgumentsMapChildren;
        if (inputArgumentsListElement != null)
        {
            ManagedMap<String, String> inputArguments = new ManagedMap<String, String>();
            inputArgumentsMapChildren = DomUtils.getChildElementsByTagName(inputArgumentsListElement, INPUT_ARGUMENT_TAG_NAME);
            if (inputArgumentsMapChildren != null)
            {
                for (Element inputArgumentsChild : inputArgumentsMapChildren)
                {
                    final String valueObject = inputArgumentsChild.getTextContent();
                    final String keyObject = inputArgumentsChild.getAttribute(KEY_ATTRIBUTE);
                    inputArguments.put(keyObject, valueObject);
                }
            }
            builder.addPropertyValue(INPUT_ARGUMENTS, inputArguments);
        }
    }
}
