/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.module.datamapper.i18n;

import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;

public class DataMapperMessages extends MessageFactory
{

    private static final String BUNDLE_PATH = getBundlePath("datamapper");

    public Message createNoDefaultConfig(int configFounds)
    {
        return createStaticMessage("If config-ref attribute is not specified there should be only ONE DataMapper config element defined. Elements found : " + configFounds + " expected : 1.");
    }

    public Message createNoLicenseFound()
    {
        return createStaticMessage("Invalid license for MuleSoft DataMapper, please contact MuleSoft info@mulesoft.com");
    }

    public Message createReturnClassError()
    {
        return createStaticMessage("Return class attribute is not valid");
    }


}