/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.module.datamapper.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

public class BlockingPipeList<T> implements List<T>, Closeable
{

    private final Semaphore maxSize;
    private final Object emptySize;
    private boolean closed;
    private final ConcurrentLinkedQueue<T> cache;


    public BlockingPipeList(int pipeSize)
    {
        maxSize = new Semaphore(pipeSize, true);
        emptySize = new Object();
        closed = false;
        cache = new ConcurrentLinkedQueue<T>();
    }

    @Override
    public boolean add(T t)
    {
        if (closed)
        {
            throw new RuntimeException("Closed Pipe");
        }
        try
        {
            maxSize.acquire();
            synchronized (emptySize)
            {
                boolean result = cache.add(t);
                emptySize.notify();
                return result;
            }
        }
        catch (InterruptedException e)
        {
            throw new RuntimeException("Un expected exception", e);
        }

    }

    @Override
    public boolean remove(Object o)
    {
        throw new UnsupportedOperationException("Remove at is not supported");
    }

    @Override
    public boolean containsAll(Collection<?> objects)
    {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> values)
    {
        for (T value : values)
        {
            add(value);
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> ts)
    {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    @Override
    public boolean removeAll(Collection<?> objects)
    {
        throw new UnsupportedOperationException("removeAll  is not supported");
    }

    @Override
    public boolean retainAll(Collection<?> objects)
    {
        throw new UnsupportedOperationException("retainAll  is not supported");
    }

    @Override
    public void clear()
    {
        throw new UnsupportedOperationException("clear is not supported");
    }

    @Override
    public T get(int i)
    {
        throw new UnsupportedOperationException("get is not supported");
    }

    @Override
    public T set(int i, T t)
    {
        throw new UnsupportedOperationException("set is not supported");
    }

    @Override
    public void add(int i, T t)
    {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public T remove(int i)
    {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public void close()
    {
        closed = true;


        synchronized (emptySize)
        {
            emptySize.notify();
        }
    }

    @Override
    public int size()
    {
        throw new UnsupportedOperationException("size is not supported");
    }

    @Override
    public boolean isEmpty()
    {
        throw new UnsupportedOperationException("isEmpty is not supported");
    }

    @Override
    public boolean contains(Object o)
    {
        throw new UnsupportedOperationException("contains is not supported");
    }

    @Override
    public Iterator<T> iterator()
    {
        return new BlockingPileListIterator();
    }

    @Override
    public Object[] toArray()
    {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public <T1 extends Object> T1[] toArray(T1[] t1s)
    {
        throw new UnsupportedOperationException("toArray at is not supported");
    }

    @Override
    public int indexOf(Object o)
    {
        throw new UnsupportedOperationException("indexOf at is not supported");
    }

    @Override
    public int lastIndexOf(Object o)
    {
        throw new UnsupportedOperationException("lastIndexOf at is not supported");
    }

    @Override
    public ListIterator<T> listIterator()
    {
        throw new UnsupportedOperationException("listIterator at is not supported");
    }

    @Override
    public ListIterator<T> listIterator(int i)
    {
        throw new UnsupportedOperationException("listIterator at is not supported");
    }

    @Override
    public List<T> subList(int i, int i2)
    {
        throw new UnsupportedOperationException("subList at is not supported");
    }


    class BlockingPileListIterator implements Iterator<T>, Closeable
    {

        @Override
        public boolean hasNext()
        {
            synchronized (emptySize)
            {
                if (cache.isEmpty() && !closed)
                { //Wait till closed or till someone add some element
                    try
                    {
                        emptySize.wait();
                    }
                    catch (InterruptedException e)
                    {
                        e.printStackTrace();
                    }
                }
            }

            return !closed || !cache.isEmpty();
        }

        @Override
        public T next()
        {
            T result = cache.poll();
            maxSize.release();
            return result;
        }

        @Override
        public void remove()
        {
            throw new UnsupportedOperationException("Add at is not supported");
        }

        @Override
        public void close() throws IOException
        {
            BlockingPipeList.this.close();
        }
    }


}
