/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.util;

/**
 * Simple thread-safe counter.
 *
 * @author jan.michalica
 */
public class Counter
{

    private int count;
    private final Object lock = new Object();

    public Counter(int count)
    {
        this.count = count;
    }

    public Counter()
    {
        this(0);
    }

    public void increment()
    {
        synchronized (lock)
        {
            ++count;
            lock.notifyAll();
        }
    }

    public void decrement() throws InterruptedException
    {
        synchronized (lock)
        {
            while (count <= 0)
            {
                lock.wait();
            }
            --count;
            lock.notifyAll();
        }
    }

    public void await(final int count) throws InterruptedException
    {
        if (count < 0)
        {
            throw new IllegalArgumentException("Cannot await negative count.");
        }
        synchronized (lock)
        {
            while (this.count != count)
            {
                lock.wait();
            }
        }
    }

    public int getCount()
    {
        return count;
    }
}
