/**
 *
 */
package com.mulesoft.mule.module.datamapper.util;

import org.mule.api.MuleContext;
import org.mule.api.config.MuleProperties;
import org.mule.util.IOUtils;

import com.mulesoft.datamapper.exception.DataMapperRuntimeException;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CloverEventFilter;

import java.io.File;
import java.io.IOException;
import java.net.URL;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DataMapperUtils
{

    private static final boolean validation = false;


    private static final boolean putCDATAIntoText = true;
    private static final boolean createEntityRefs = false;
    public static final String FILTERUNSEDMETADATA_PROPERTY = "com.mulesoft.datamapper.filterunsedmetadata";

    public static String getAppHome(MuleContext muleContext)
    {
        return muleContext.getRegistry().get(MuleProperties.APP_HOME_DIRECTORY_PROPERTY);
    }

    public static File getMappingFile(MuleContext muleContext, String grfName)
    {
        return new File(getAppHome(muleContext), grfName);
    }


    public static Document parseDocument(MuleContext muleContext, String grfName)
    {


        DOMResult result = new DOMResult();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty(XMLInputFactory.IS_NAMESPACE_AWARE, true);
        xmlInputFactory.setProperty(XMLInputFactory.IS_COALESCING, putCDATAIntoText);
        xmlInputFactory.setProperty(XMLInputFactory.IS_VALIDATING, validation);
        xmlInputFactory.setProperty(XMLInputFactory.IS_REPLACING_ENTITY_REFERENCES, createEntityRefs);

        XMLEventReader reader;
        Document document;
        try
        {
            File mappingFile = getMappingFile(muleContext, grfName);
            StreamSource source;

            if (!mappingFile.exists())
            {
                URL resourceAsUrl = IOUtils.getResourceAsUrl(grfName, DataMapperUtils.class);
                if (resourceAsUrl == null)
                {
                    throw new DataMapperRuntimeException("The data mapping graph " + grfName + " does not exists");
                }
                try
                {
                    source = new StreamSource(resourceAsUrl.openStream());
                }
                catch (IOException e)
                {
                    throw new DataMapperRuntimeException("Problem when loading " + grfName + " .", e);
                }
            }
            else
            {
                source = new StreamSource(mappingFile);
            }
            reader = xmlInputFactory.createXMLEventReader(source);
            if (Boolean.getBoolean(FILTERUNSEDMETADATA_PROPERTY))
            {
                reader = xmlInputFactory.createFilteredReader(reader, new CloverEventFilter());
            }
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(new StaxSource(reader), result);

            document = (Document) result.getNode();
        }
        catch (XMLStreamException e)
        {
            throw new DataMapperRuntimeException(e);
        }
        catch (TransformerConfigurationException e)
        {
            throw new DataMapperRuntimeException(e);
        }
        catch (TransformerException e)
        {
            throw new DataMapperRuntimeException(e);
        }

        return document;
    }

    public static class StaxSource extends SAXSource
    {

        private XMLEventReader eventReader;


        /**
         * Constructs a new instance of the <code>StaxSource</code> with the specified <code>XMLEventReader</code>. The
         * supplied event reader must be in <code>XMLStreamConstants.START_DOCUMENT</code> or
         * <code>XMLStreamConstants.START_ELEMENT</code> state.
         *
         * @param eventReader the <code>XMLEventReader</code> to read from
         * @throws IllegalStateException if the reader is not at the start of a document or element
         */
        public StaxSource(XMLEventReader eventReader)
        {
            super(new StaxEventXMLReader(eventReader), new InputSource());
            this.eventReader = eventReader;
        }

        /**
         * Returns the <code>XMLEventReader</code> used by this <code>StaxSource</code>. If this <code>StaxSource</code> was
         * created with an <code>XMLStreamReader</code>, the result will be <code>null</code>.
         *
         * @return the StAX event reader used by this source
         * @see StaxSource#StaxSource(javax.xml.stream.XMLEventReader)
         */
        XMLEventReader getXMLEventReader()
        {
            return eventReader;
        }

        /**
         * Returns the <code>XMLStreamReader</code> used by this <code>StaxSource</code>. If this <code>StaxSource</code> was
         * created with an <code>XMLEventReader</code>, the result will be <code>null</code>.
         *
         * @return the StAX event reader used by this source
         * @see StaxSource#StaxSource(javax.xml.stream.XMLEventReader)
         */


        /**
         * Throws a <code>UnsupportedOperationException</code>.
         *
         * @throws UnsupportedOperationException always
         */
        @Override
        public void setInputSource(InputSource inputSource)
        {
            throw new UnsupportedOperationException("setInputSource is not supported");
        }

        /**
         * Throws a <code>UnsupportedOperationException</code>.
         *
         * @throws UnsupportedOperationException always
         */
        @Override
        public void setXMLReader(XMLReader reader)
        {
            throw new UnsupportedOperationException("setXMLReader is not supported");
        }
    }
}
