/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.util;

import java.util.Arrays;
import java.util.List;

import org.jetel.data.DataRecord;
import org.jetel.metadata.DataRecordMetadata;

public class DataRecordFactory
{

    private List<DataRecordBuilder> builders = Arrays.asList(new MapDataRecordBuilder(), new PojoDataRecordBuilder());

    public DataRecord buildFrom(DataRecordMetadata metadata, Object source)
    {
        for (DataRecordBuilder builder : builders)
        {
            if (builder.handles(source))
            {
                return builder.buildFrom(metadata, source);
            }
        }
        return new DataRecord(metadata);
    }
}
