/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.util;

import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.metadata.DataFieldType;

public class DataRecordUtils
{

    public Object[] getValues(DataRecord dataRecord)
    {
        if (dataRecord == null)
        {
            return new Object[0];
        }
        final Object[] result = new Object[dataRecord.getNumFields()];
        for (int i = 0; i < dataRecord.getNumFields(); i++)
        {
            DataField dataField = dataRecord.getField(i);
            if (dataField != null && !dataField.isNull())
            {
                // Here we can modify the datatype according to field
                // type
                Object value = dataField.getValue();
                //is this required
                if (dataField.getMetadata().getDataType().equals(DataFieldType.STRING) && value != null)
                {
                    value = value.toString();
                }
                result[i] = value;
            }
        }
        return result;
    }

}