/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.util;

import java.util.Map;

import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.metadata.DataRecordMetadata;

public class MapDataRecordBuilder implements DataRecordBuilder
{


    @Override
    public boolean handles(Object object)
    {
        return object instanceof Map;
    }

    @Override
    public DataRecord buildFrom(DataRecordMetadata metadata, Object input)
    {
        Map<String, Object> data = (Map<String, Object>) input;
        if (data == null)
        {
            return new DataRecord(metadata);
        }
        DataRecord result = new DataRecord(metadata);
        result.init();

        for (String key : data.keySet())
        {
            Object value = data.get(key);
            addFieldIfExistsMetadata(result, key, value);
        }
        return result;


    }

    private void addFieldIfExistsMetadata(DataRecord dataRecord, String key, Object value)
    {
        String fieldName = key;
        if (dataRecord.hasField(fieldName))
        {
            DataField dataField = dataRecord.getField(fieldName);

            if (dataField != null)
            {
                dataField.setValue(value);
            }
        }
    }
}
