/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.mule.module.datamapper.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.metadata.DataRecordMetadata;

public class PojoDataRecordBuilder implements DataRecordBuilder
{

    private static Logger logger = Logger.getLogger(PojoDataRecordBuilder.class.getName());

    @Override
    public boolean handles(Object object)
    {
        return !(object instanceof Map);
    }

    @Override
    public DataRecord buildFrom(DataRecordMetadata metadata, Object pojo)
    {
        if (pojo == null)
        {
            return new DataRecord(metadata);
        }

        BeanInfo beanInfo;
        try
        {
            beanInfo = Introspector.getBeanInfo(pojo.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();

            DataRecord record = new DataRecord(metadata);
            record.init();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors)
            {
                if (propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getReadMethod() != null)
                {
                    Object value = null;
                    try
                    {
                        value = propertyDescriptor.getReadMethod().invoke(pojo);
                    }
                    catch (Exception e)
                    {
                        logger.log(Level.WARNING, "Error invoking reflect method", e);
                    }

                    addFieldIfExistsMetadata(record, propertyDescriptor.getName(), value);
                }
            }
            return record;
        }
        catch (IntrospectionException e)
        {
            logger.log(Level.WARNING, "Error invoking reflect method", e);
        }

        return null;

    }

    private void addFieldIfExistsMetadata(DataRecord dataRecord, String key, Object value)
    {
        String fieldName = key.toLowerCase();
        if (dataRecord.hasField(fieldName))
        {
            DataField dataField = dataRecord.getField(fieldName);
            if (dataField != null)
            {
                dataField.setValue(value);
            }
        }
    }
}
