/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.el.mvel;

import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.integration.impl.BaseVariableResolverFactory;
import org.mule.mvel2.integration.impl.ClassImportResolverFactory;

import com.mulesoft.datamapper.transform.LookupTableAware;

import org.jetel.data.DataRecord;
import org.jetel.graph.dictionary.Dictionary;

public class DataMapperExpressionLanguage
{

    public static final String INPUT_ARGUMENTS = "inputArguments";
    public static final String OUTPUT_ARGUMENTS = "outputArguments";

    private MuleContext muleContext;
    private ParserConfiguration dmParserConfiguration;
    private MVELExpressionLanguageContext dmStaticContext;
    private VariableResolverFactory muleGlobalVariableResolverFactory;
    private BaseVariableResolverFactory classImportResolverFactory;
    private VariableResolverFactory staticResolverFactory;
    private ExpressionExecutor<MVELExpressionLanguageContext> executor;

    public DataMapperExpressionLanguage(MuleContext muleContext,
                                        ClassLoader classLoader,
                                        LookupTableAware lookupTableAware,
                                        Dictionary dictionary)
    {
        this.muleContext = muleContext;
        ParserConfiguration muleParserConfig = getMVELExpressionLanguage().getParserConfiguration();
        dmParserConfiguration = new ParserConfiguration();
        dmParserConfiguration.setClassLoader(classLoader);
        executor = new MVELExpressionExecutor(dmParserConfiguration);
        dmStaticContext = new DataMapperStaticContext(dmParserConfiguration, muleContext, lookupTableAware,
            dictionary);
        muleGlobalVariableResolverFactory = new GlobalVariableResolverFactory(
            getMVELExpressionLanguage().getAliases(), getMVELExpressionLanguage().getGlobalFunctions(),
            dmParserConfiguration, muleContext);
        classImportResolverFactory = new ClassImportResolverFactory(new ParserConfiguration(
            muleParserConfig.getImports(), muleParserConfig.getPackageImports(), null), null, true);
        staticResolverFactory = new StaticVariableResolverFactory(dmParserConfiguration, muleContext);
        classImportResolverFactory.setNextFactory(staticResolverFactory);
        staticResolverFactory.setNextFactory(muleGlobalVariableResolverFactory);
    }

    public <T> T evaluate(String expression, DataRecord[] inputRecords, DataRecord outputRecord)
    {
        MVELExpressionLanguageContext expressionLanguageContext = createDMExpressionLanguageContext(
            dmParserConfiguration, inputRecords, outputRecord);

        try
        {
            return (T) executor.execute(expression, expressionLanguageContext);
        }
        catch (Exception e)
        {
            throw new ExpressionRuntimeException(CoreMessages.expressionEvaluationFailed(expression), e);
        }
    }

    private MVELExpressionLanguage getMVELExpressionLanguage()
    {
        return (MVELExpressionLanguage) muleContext.getExpressionLanguage();
    }

    protected MVELExpressionLanguageContext createDMExpressionLanguageContext(ParserConfiguration parserConfiguration,
                                                                              DataRecord[] inputRecords,
                                                                              final DataRecord outputRecord)
    {
        DataMapperExpressionLanguageContext expressionLanguageContext = new DataMapperExpressionLanguageContext(
            parserConfiguration, muleContext, inputRecords, outputRecord, dmStaticContext);
        expressionLanguageContext.appendFactory(classImportResolverFactory);
        return expressionLanguageContext;
    }
}
