/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.el.mvel;

import org.mule.api.MuleContext;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;
import org.mule.mvel2.integration.VariableResolverFactory;

import com.mulesoft.datamapper.transform.DataRecordContext;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.map.UnmodifiableMap;
import org.jetel.data.DataRecord;

public class DataMapperExpressionLanguageContext extends MVELExpressionLanguageContext
{

    private static final long serialVersionUID = -1230130134148731200L;

    public static final String INPUT = "input";
    public static final String OUTPUT = "output";

    private VariableResolver inputRecordsResolver;
    private VariableResolver outputRecordResolver;
    private VariableResolverFactory staticResolverFactory;

    public DataMapperExpressionLanguageContext(ParserConfiguration parserConfiguration,
                                               MuleContext muleContext,
                                               DataRecord[] inputRecords,
                                               final DataRecord outputRecord,
                                               VariableResolverFactory staticResolverFactory)
    {
        super(parserConfiguration, muleContext);
        this.staticResolverFactory = staticResolverFactory;
        if (inputRecords.length > 1)
        {
            int i = 0;
            Map<String, DataRecordContext> input = new HashMap<String, DataRecordContext>();
            for (DataRecord inputRecord : inputRecords)
            {
                input.put(String.valueOf(i), new DataRecordContext(inputRecord));
                input.put(inputRecord.getMetadata().getLabelOrName(), new DataRecordContext(inputRecord));
                i++;
            }
            inputRecordsResolver = new MuleImmutableVariableResolver<Map>(INPUT,
                UnmodifiableMap.decorate(input), null);
        }
        else if (inputRecords.length == 1)
        {
            inputRecordsResolver = new MuleImmutableVariableResolver<DataRecordContext>(INPUT,
                new DataRecordContext(inputRecords[0]), null);
        }
        outputRecordResolver = new MuleImmutableVariableResolver<DataRecordContext>(OUTPUT,
            new DataRecordContext(outputRecord), null);
    }

    @Override
    public boolean isTarget(String name)
    {
        return INPUT.equals(name) || OUTPUT.equals(name) || staticResolverFactory.isTarget(name)
               || super.isTarget(name);
    }

    @Override
    public VariableResolver getVariableResolver(String name)
    {
        if (INPUT.equals(name))
        {
            return inputRecordsResolver;
        }
        else if (OUTPUT.equals(name))
        {
            return outputRecordResolver;
        }
        else
        {
            VariableResolver vr = staticResolverFactory.getVariableResolver(name);
            if (vr == null)
            {
                vr = super.getVariableResolver(name);
            }
            return vr;
        }
    }

}
