/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.el.mvel;

import org.mule.api.MuleContext;
import org.mule.mvel2.ParserConfiguration;
import org.mule.mvel2.integration.VariableResolver;

import com.mulesoft.datamapper.transform.InputArgumentContext;
import com.mulesoft.datamapper.transform.LookupTableAware;
import com.mulesoft.datamapper.transform.OutputArgumentContext;
import com.mulesoft.datamapper.transform.function.Bool2NumFunction;
import com.mulesoft.datamapper.transform.function.Calendar2DateFunction;
import com.mulesoft.datamapper.transform.function.Calendar2LongFunction;
import com.mulesoft.datamapper.transform.function.Calendar2NumFunction;
import com.mulesoft.datamapper.transform.function.Calendar2StrFunction;
import com.mulesoft.datamapper.transform.function.Date2CalendarFunction;
import com.mulesoft.datamapper.transform.function.Date2LongFunction;
import com.mulesoft.datamapper.transform.function.Date2NumFunction;
import com.mulesoft.datamapper.transform.function.Date2StrFunction;
import com.mulesoft.datamapper.transform.function.Decimal2DoubleFunction;
import com.mulesoft.datamapper.transform.function.Decimal2IntegerFunction;
import com.mulesoft.datamapper.transform.function.Decimal2LongFunction;
import com.mulesoft.datamapper.transform.function.Double2IntegerFunction;
import com.mulesoft.datamapper.transform.function.Double2LongFunction;
import com.mulesoft.datamapper.transform.function.FlowRefFunction;
import com.mulesoft.datamapper.transform.function.InvokeTransformerFunction;
import com.mulesoft.datamapper.transform.function.IsNullFunction;
import com.mulesoft.datamapper.transform.function.Long2CalendarFunction;
import com.mulesoft.datamapper.transform.function.Long2DateFunction;
import com.mulesoft.datamapper.transform.function.Long2IntegerFunction;
import com.mulesoft.datamapper.transform.function.LookupFunction;
import com.mulesoft.datamapper.transform.function.Num2BoolFunction;
import com.mulesoft.datamapper.transform.function.Num2StrFunction;
import com.mulesoft.datamapper.transform.function.Str2BoolFunction;
import com.mulesoft.datamapper.transform.function.Str2CalendarFunction;
import com.mulesoft.datamapper.transform.function.Str2DateFunction;
import com.mulesoft.datamapper.transform.function.Str2DecimalFunction;
import com.mulesoft.datamapper.transform.function.Str2DoubleFunction;
import com.mulesoft.datamapper.transform.function.Str2IntegerFunction;
import com.mulesoft.datamapper.transform.function.Str2LongFunction;

import java.util.Iterator;

import org.jetel.ctl.data.DateFieldEnum;
import org.jetel.data.lookup.LookupTable;

/**
 * Created by machaval on 1/24/14.
 */
public class DataMapperStaticContext extends MVELExpressionLanguageContext
{

    private LookupTableAware lookupTableAware;

    public DataMapperStaticContext(ParserConfiguration parserConfiguration,
                                   MuleContext muleContext,
                                   LookupTableAware lookupTableAware,
                                   org.jetel.graph.dictionary.Dictionary dictionary)
    {
        super(parserConfiguration, muleContext);
        this.lookupTableAware = lookupTableAware;

        // Imports
        importClass(LookupTable.class);
        importClass(DateFieldEnum.class);

        // Functions
        declareDefaultFunctions();

        // Variables
        DateFieldEnum[] values = DateFieldEnum.values();
        for (DateFieldEnum value : values)
        {
            addVariable(value.name(), value);
            // CTL Compatibility
            addVariable(value.name().toLowerCase(), value);
        }
        Iterator<String> lookupTables = lookupTableAware.getLookupTables();
        while (lookupTables.hasNext())
        {
            String lookupName = lookupTables.next();
            addVariable(lookupName, lookupTableAware.getLookupTable(lookupName));
        }
        addVariable(DataMapperExpressionLanguage.INPUT_ARGUMENTS, new InputArgumentContext(dictionary));
        addVariable(DataMapperExpressionLanguage.OUTPUT_ARGUMENTS, new OutputArgumentContext(dictionary));
    }

    private void declareDefaultFunctions()
    {
        declareFunction("lookup", new LookupFunction(lookupTableAware));
        declareFunction("isnull", new IsNullFunction());

        declareFunction("str2bool", new Str2BoolFunction());
        declareFunction("str2date", new Str2DateFunction());
        declareFunction("str2decimal", new Str2DecimalFunction());
        declareFunction("str2double", new Str2DoubleFunction());
        declareFunction("str2integer", new Str2IntegerFunction());
        declareFunction("str2long", new Str2LongFunction());
        declareFunction("str2calendar", new Str2CalendarFunction());

        declareFunction("num2str", new Num2StrFunction());
        declareFunction("num2bool", new Num2BoolFunction());

        declareFunction("long2date", new Long2DateFunction());
        declareFunction("long2integer", new Long2IntegerFunction());
        declareFunction("long2calendar", new Long2CalendarFunction());

        declareFunction("double2integer", new Double2IntegerFunction());
        declareFunction("double2long", new Double2LongFunction());

        declareFunction("decimal2integer", new Decimal2IntegerFunction());
        declareFunction("decimal2long", new Decimal2LongFunction());
        declareFunction("decimal2double", new Decimal2DoubleFunction());

        declareFunction("bool2num", new Bool2NumFunction());

        declareFunction("date2str", new Date2StrFunction());
        declareFunction("date2num", new Date2NumFunction());
        declareFunction("date2long", new Date2LongFunction());
        declareFunction("date2calendar", new Date2CalendarFunction());

        declareFunction("calendar2date", new Calendar2DateFunction());
        declareFunction("calendar2long", new Calendar2LongFunction());
        declareFunction("calendar2number", new Calendar2NumFunction());
        declareFunction("calendar2str", new Calendar2StrFunction());

        declareFunction("flowRef", new FlowRefFunction(muleContext));
        declareFunction("invokeTransformer", new InvokeTransformerFunction(muleContext));
    }

    public VariableResolver getVariableResolver(String name)
    {
        return variableResolvers.get(name);
    }

    @Override
    public boolean isTarget(String name)
    {
        return variableResolvers.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name)
    {
        return isTarget(name);
    }

}
