/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform;

import com.mulesoft.datamapper.transform.converter.ScalarValueConversion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetel.data.DataField;
import org.jetel.data.DataRecord;
import org.jetel.data.DecimalDataField;
import org.jetel.data.ListDataField;
import org.jetel.data.StringDataField;
import org.mule.el.context.AbstractMapContext;

public class DataRecordContext
extends AbstractMapContext<String, Object> {
    private DataRecord dataRecord;
    private ScalarValueConversion conversion = ScalarValueConversion.theInstance();

    public DataRecordContext(DataRecord dataRecord) {
        this.dataRecord = dataRecord;
    }

    public boolean containsKey(Object key) {
        return this.dataRecord.hasField(String.valueOf(key));
    }

    public Object get(Object key) {
        DataField field = this.dataRecord.getField(String.valueOf(key));
        if (field != null) {
            return this.getDataFieldValue(field);
        }
        throw new IllegalArgumentException("Field '" + String.valueOf(key) + "' is not declared at  " + this.dataRecord.getMetadata().getName());
    }

    private Object getDataFieldValue(DataField field) {
        if (field.isNull()) {
            return null;
        }
        if (field instanceof StringDataField) {
            return field.getValue().toString();
        }
        if (field instanceof DecimalDataField) {
            return ((DecimalDataField)field).getBigDecimal();
        }
        if (field instanceof ListDataField) {
            ListDataField cloverList = (ListDataField)field;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < cloverList.getSize(); ++i) {
                list.add(this.getDataFieldValue(cloverList.getField(i)));
            }
            return list;
        }
        return field.getValue();
    }

    public Object put(String key, Object value) {
        DataField field = this.dataRecord.getField(key);
        if (field != null) {
            this.setDataFieldValue(field, value);
            return value;
        }
        throw new IllegalArgumentException("Field '" + String.valueOf(key) + "' is not declared at  " + this.dataRecord.getMetadata().getName());
    }

    private void setDataFieldValue(DataField field, Object value) {
        if (value == null) {
            field.setNull(true);
        } else if (field instanceof StringDataField) {
            field.setValue((Object)value.toString());
        } else if (field instanceof ListDataField) {
            ListDataField cloverList = (ListDataField)field;
            Class<?> listType = field.getMetadata().getDataType().getInternalValueClass();
            if (listType.isArray()) {
                listType = listType.getComponentType();
            }
            cloverList.setValue(this.conversion.convertList(value, listType));
        } else {
            Class desiredType = field.getMetadata().getDataType().getInternalValueClass();
            if (desiredType == value.getClass()) {
                field.setValue(value);
            } else {
                field.setValue(this.conversion.convert(value, desiredType));
            }
        }
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException("Can not remove from a data record");
    }

    public void clear() {
        throw new UnsupportedOperationException("Can not clear a data record");
    }

    public Set<String> keySet() {
        return new HashSet<String>(Arrays.asList(this.dataRecord.getMetadata().getFieldNamesArray()));
    }
}

