/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform;

import com.mulesoft.datamapper.mule.MuleContextAccessor;
import com.mulesoft.datamapper.mule.MuleContextAccessorFactory;
import com.mulesoft.datamapper.transform.LookupTableAwareImpl;
import org.jetel.component.DataRecordTransform;
import org.jetel.data.DataRecord;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.exception.TransformException;
import org.mule.el.mvel.DataMapperExpressionLanguage;

public class MelRecordTransform
extends DataRecordTransform {
    public static final String MEL_SCRIPT = "melScript";
    private DataMapperExpressionLanguage dmExpressionLanguage;
    private MuleContextAccessor muleContextAccessor;

    private void initIfRequired() {
        if (this.dmExpressionLanguage == null) {
            this.muleContextAccessor = MuleContextAccessorFactory.create(this.getGraph().getDictionary());
            this.dmExpressionLanguage = new DataMapperExpressionLanguage(this.muleContextAccessor.getMuleContext(), this.getGraph().getRuntimeContext().getClassLoader(), new LookupTableAwareImpl(this.getGraph()), this.getGraph().getDictionary());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int transform(DataRecord[] inputRecords, DataRecord[] outputRecords) throws TransformException {
        this.initIfRequired();
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = this.getGraph().getRuntimeContext().getClassLoader();
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        try {
            String transform = this.parameters.getProperty(MEL_SCRIPT);
            this.dmExpressionLanguage.evaluate(transform, inputRecords, outputRecords[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        return 0;
    }

    public void postExecute() throws ComponentNotReadyException {
        super.postExecute();
        if (this.muleContextAccessor != null) {
            this.muleContextAccessor.postExecute();
        }
    }
}

