/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform;

import java.util.HashSet;
import java.util.Set;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.graph.dictionary.Dictionary;
import org.mule.el.context.AbstractMapContext;

public class OutputArgumentContext
extends AbstractMapContext<String, Object> {
    private Dictionary dictionary;

    public OutputArgumentContext(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public boolean containsKey(Object key) {
        return this.dictionary.isOutput(String.valueOf(key));
    }

    public Object get(Object key) {
        if (!this.containsKey(key)) {
            throw new IllegalArgumentException("Output Argument '" + String.valueOf(key) + "' is not declared.");
        }
        return this.dictionary.getValue(String.valueOf(key));
    }

    public Object put(String s, Object o) {
        Object oldValue = this.get(s);
        if (this.dictionary.isOutput(s)) {
            try {
                this.dictionary.setValue(s, o);
            }
            catch (ComponentNotReadyException e) {
                e.printStackTrace();
            }
        } else {
            throw new UnsupportedOperationException("Entry is not output type and can not be assigned");
        }
        return oldValue;
    }

    public Object remove(Object o) {
        return null;
    }

    public void clear() {
    }

    public Set<String> keySet() {
        HashSet<String> result = new HashSet<String>();
        Set dictionaryKeys = this.dictionary.getKeys();
        for (String key : dictionaryKeys) {
            if (!this.dictionary.isOutput(key)) continue;
            result.add(key);
        }
        return result;
    }
}

