/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.jetel.data.primitive.Decimal;
import org.jetel.data.primitive.DecimalFactory;

public class DecimalConverter
extends AbstractConverter {
    protected Object convertToType(Class type, Object value) throws Throwable {
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return DecimalFactory.getDecimal((BigDecimal)bd);
        }
        if (value instanceof BigInteger) {
            BigInteger bi = (BigInteger)value;
            return DecimalFactory.getDecimal((BigDecimal)new BigDecimal(bi));
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return DecimalFactory.getDecimal((int)number.intValue());
        }
        if (value instanceof Float || value instanceof Double) {
            Number number = (Number)value;
            return DecimalFactory.getDecimal((double)number.doubleValue());
        }
        if (value instanceof Long) {
            Number number = (Number)value;
            return DecimalFactory.getDecimal((long)number.longValue());
        }
        if (value instanceof String) {
            try {
                return DecimalFactory.getDecimal((String)((String)value));
            }
            catch (NumberFormatException e) {
                throw new ConversionException("Cannot convert " + value + " to " + type, (Throwable)e);
            }
        }
        throw new ConversionException("Cannot convert " + value + " to " + type);
    }

    protected Class getDefaultType() {
        return Decimal.class;
    }
}

