/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.converter;

import com.mulesoft.datamapper.transform.converter.BigDecimalConverter;
import com.mulesoft.datamapper.transform.converter.CloverStringConverter;
import com.mulesoft.datamapper.transform.converter.DecimalConverter;
import com.mulesoft.datamapper.transform.converter.EnumConverter;
import com.mulesoft.datamapper.transform.converter.UriConverter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BigIntegerConverter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CalendarConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimeConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.commons.beanutils.converters.URLConverter;
import org.jetel.data.primitive.Decimal;
import org.jetel.util.string.CloverString;

public class ScalarValueConversion {
    private static ScalarValueConversion sharedInstance;
    private Map<Class, Converter> converterMap = new HashMap<Class, Converter>();
    private Map<Class, Class> boxMap = new HashMap<Class, Class>();

    public static ScalarValueConversion theInstance() {
        if (sharedInstance == null) {
            sharedInstance = new ScalarValueConversion();
        }
        return sharedInstance;
    }

    protected ScalarValueConversion() {
        this.init();
    }

    protected void init() {
        this.register((Converter)new BigIntegerConverter(), BigInteger.class);
        this.register((Converter)new BooleanConverter((Object)Boolean.FALSE), Boolean.TYPE);
        this.register((Converter)new BooleanConverter(), Boolean.class);
        this.register((Converter)new CharacterConverter((Object)Character.valueOf('\u0000')), Character.TYPE);
        this.register((Converter)new CharacterConverter(), Character.class);
        this.register((Converter)new ByteConverter((Object)0), Byte.TYPE);
        this.register((Converter)new ByteConverter(), Byte.class);
        this.register((Converter)new DoubleConverter((Object)0.0), Double.TYPE);
        this.register((Converter)new DoubleConverter(), Double.class);
        this.register((Converter)new FloatConverter((Object)Float.valueOf(0.0f)), Float.TYPE);
        this.register((Converter)new FloatConverter(), Float.class);
        this.register((Converter)new IntegerConverter((Object)0), Integer.TYPE);
        this.register((Converter)new IntegerConverter(), Integer.class);
        this.register((Converter)new LongConverter((Object)0L), Long.TYPE);
        this.register((Converter)new LongConverter(), Long.class);
        this.register((Converter)new ShortConverter((Object)0), Short.TYPE);
        this.register((Converter)new ShortConverter(), Short.class);
        this.register((Converter)new StringConverter(), String.class);
        this.register((Converter)new URLConverter(), URL.class);
        this.register((Converter)new DateConverter(), java.util.Date.class);
        this.register((Converter)new CalendarConverter(), Calendar.class);
        this.register((Converter)new DateConverter(), java.util.Date.class);
        this.register((Converter)new SqlDateConverter(), Date.class);
        this.register((Converter)new SqlTimeConverter(), Time.class);
        this.register((Converter)new SqlTimestampConverter(), Timestamp.class);
        this.register((Converter)new UriConverter(), URI.class);
        this.register(new CloverStringConverter(), CloverString.class);
        this.register(new EnumConverter(), Enum.class);
        this.register((Converter)new DecimalConverter(), Decimal.class);
        this.register(new BigDecimalConverter(), BigDecimal.class);
        this.registerBox(Byte.TYPE, Byte.class);
        this.registerBox(Integer.TYPE, Integer.class);
        this.registerBox(Long.TYPE, Long.class);
        this.registerBox(Double.TYPE, Double.class);
        this.registerBox(Boolean.TYPE, Boolean.class);
        this.registerBox(Character.TYPE, Character.class);
        this.registerBox(Float.TYPE, Float.class);
    }

    private void register(Converter converter, Class<?> clazz) {
        this.converterMap.put(clazz, converter);
    }

    private void registerBox(Class<?> primitive, Class<?> box) {
        this.boxMap.put(primitive, box);
    }

    public Object convert(Object value, Class<?> desiredType) throws ConversionException {
        if (value == null) {
            return null;
        }
        if (desiredType == null) {
            throw new ConversionException("target type null");
        }
        if (value != null && (desiredType.isAssignableFrom(value.getClass()) || this.isBoxingOf(desiredType, value.getClass()))) {
            return value;
        }
        return this.doConvert(desiredType, value);
    }

    private boolean isBoxingOf(Class<?> primitive, Class<?> boxType) {
        if (primitive.isPrimitive()) {
            return this.boxMap.get(primitive).equals(boxType);
        }
        return false;
    }

    private <T> Object doConvert(Class<T> desiredType, Object value) {
        if (this.converterMap.containsKey(desiredType)) {
            return this.converterMap.get(desiredType).convert(desiredType, value);
        }
        for (Map.Entry<Class, Converter> classConverterEntry : this.converterMap.entrySet()) {
            if (!desiredType.isAssignableFrom(classConverterEntry.getKey())) continue;
            return this.converterMap.get(desiredType).convert(desiredType, value);
        }
        throw new RuntimeException("No converter found for type " + desiredType);
    }

    public List<?> convertList(Object value, Class<?> desiredType) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List valueAsList = (List)value;
            ArrayList<Object> result = new ArrayList<Object>(valueAsList.size());
            for (Object element : valueAsList) {
                result.add(this.convert(element, desiredType));
            }
            return result;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                result.add(this.convert(Array.get(value, i), desiredType));
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.convert(value, desiredType));
        return result;
    }
}

