/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.util.Calendar;
import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

public class Calendar2NumFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 2) {
            if (params[0] == null) {
                return null;
            }
            if (!this.isInteger(params[1])) {
                throw new IllegalArgumentException("Invalid call " + this.getSignatureFromParams("calendar2num", params) + " to calendar2num(Calendar calendar,Integer calendarUnit)");
            }
            Integer calendarConstant = (Integer)params[1];
            if (this.isString(params[0])) {
                return Calendar2NumFunction.calendarToNumber((String)params[0], calendarConstant);
            }
            if (this.isCalendar(params[0])) {
                return Calendar2NumFunction.calendarToNumber((Calendar)params[0], calendarConstant);
            }
        }
        throw new IllegalArgumentException("Invalid call " + this.getSignatureFromParams("calendar2num", params) + " to calendar2num(Calendar calendar,Integer calendarUnit)");
    }

    public static Integer calendarToNumber(String str_calendar, Integer calendarConstant) {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(str_calendar);
        return dateTime.toGregorianCalendar().get(calendarConstant);
    }

    public static Integer calendarToNumber(Calendar calendar, Integer calendarConstant) {
        return calendar.get(calendarConstant);
    }
}

