/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import com.mulesoft.datamapper.transform.function.DateFunctionUtils;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.mule.api.el.ExpressionLanguageContext;

public class Calendar2StrFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 2) {
            if (params[0] == null) {
                return null;
            }
            if (!this.isString(params[1])) {
                throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("calendar2str", params) + " to calendar2str(Calendar calendar,String pattern) ");
            }
            if (this.isString(params[0])) {
                String dateString = (String)params[0];
                String outputPattern = (String)params[1];
                return Calendar2StrFunction.calendarToStr(dateString, outputPattern);
            }
            if (this.isCalendar(params[0])) {
                Calendar calendar = (Calendar)params[0];
                String outputPattern = (String)params[1];
                return Calendar2StrFunction.calendarToStr(calendar, outputPattern);
            }
            if (this.isDate(params[0])) {
                Date date = (Date)params[0];
                String outputPattern = (String)params[1];
                return Calendar2StrFunction.calendarToStr(date, outputPattern);
            }
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("calendar2str", params) + " to calendar2str(Calendar calendar,String pattern) ");
    }

    public static String calendarToStr(String dateString, String outputPattern) {
        DateTime dateTime = DateFunctionUtils.parseISO8610DateTime(dateString);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }

    public static String calendarToStr(Calendar calendar, String outputPattern) {
        DateTime dateTime = new DateTime((Object)calendar);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }

    public static String calendarToStr(Date date, String outputPattern) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.toString(DateFunctionUtils.getAbsolutePattern(outputPattern));
    }
}

