/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.mule.api.el.ExpressionLanguageContext;

public class Date2CalendarFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length == 1) {
            if (this.isDate(params[0])) {
                if (params[0] == null) {
                    return null;
                }
                Date date = (Date)params[0];
                return Date2CalendarFunction.dateToCalendar(date, null);
            }
        } else {
            if (this.isDate(params[0]) && this.isString(params[1])) {
                if (params[0] == null) {
                    return null;
                }
                Date date = (Date)params[0];
                return Date2CalendarFunction.dateToCalendar(date, TimeZone.getTimeZone(String.valueOf(params[1])));
            }
            if (this.isDate(params[0]) && this.isTimeZone(params[1])) {
                if (params[0] == null) {
                    return null;
                }
                Date date = (Date)params[0];
                return Date2CalendarFunction.dateToCalendar(date, (TimeZone)params[1]);
            }
        }
        throw new IllegalArgumentException("Illegal call " + this.getSignatureFromParams("date2calendar", params) + " date2calendar(Date date) or date2calendar(Date date, String timezone)");
    }

    public static String dateToCalendar(Date date, TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        fmt = fmt.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
        return fmt.print((ReadableInstant)new DateTime((Object)date));
    }
}

