/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.transform.function;

import com.mulesoft.datamapper.transform.function.AbstractExpressionLanguageFunction;
import java.util.Calendar;
import java.util.Date;
import org.jetel.ctl.data.DateFieldEnum;
import org.mule.api.el.ExpressionLanguageContext;

public class Date2NumFunction
extends AbstractExpressionLanguageFunction {
    public Object call(Object[] params, ExpressionLanguageContext context) {
        if (params.length != 2 || !this.isDate(params[0]) || !(params[1] instanceof DateFieldEnum)) {
            throw new IllegalArgumentException("Invalid call " + this.getSignatureFromParams("date2num", params) + " date2num(Date date,DateFieldEnum unit)");
        }
        Date date = (Date)params[0];
        if (date == null) {
            return null;
        }
        DateFieldEnum timeUnit = (DateFieldEnum)params[1];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        switch (timeUnit) {
            case YEAR: {
                return calendar.get(1);
            }
            case MONTH: {
                return calendar.get(2) + 1;
            }
            case WEEK: {
                return calendar.get(3);
            }
            case DAY: {
                return calendar.get(5);
            }
            case HOUR: {
                return calendar.get(11);
            }
            case MINUTE: {
                return calendar.get(12);
            }
            case SECOND: {
                return calendar.get(13);
            }
            case MILLISEC: {
                return calendar.get(14);
            }
        }
        return null;
    }
}

