/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper;

import com.mulesoft.mule.module.datamapper.api.GraphExecutor;
import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.api.OutputArgumentHandler;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.CloverGraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManagerContainer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.transport.PropertyScope;

public class DataMapperModule
implements MuleContextAware {
    public static final String MULE_CONTEXT = "____@muleContext@____";
    public static final String MULE_EVENT = "____@muleEvent@____";
    private String transformationGraphPath;
    private GraphExecutorFactory executorFactory;
    private MuleContext muleContext;
    private GraphExecutor graphExecutor;
    private int initialPoolSize;
    private String outputContentType;
    private String outputEncoding;

    @PostConstruct
    public void initialise() {
        try {
            if (this.executorFactory == null) {
                this.executorFactory = this.createGraphExecutorFactory();
                this.executorFactory.init();
                this.graphExecutor = this.executorFactory.createGraphExecutor(this.transformationGraphPath);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private GraphExecutorFactory createGraphExecutorFactory() {
        return new CloverGraphExecutorFactory(this.muleContext, CloverEngineManagerContainer.INSTANCE.getCloverEngineManager(), this.initialPoolSize);
    }

    public void dispose() {
        this.executorFactory.dispose();
    }

    public Object transform(final MuleEvent event, Object input, Map<String, Object> inputArguments, boolean streaming, int pipeSize) throws DataMapperExecutionException, DataMapperCreationException {
        HashMap<Object, Object> arguments = inputArguments != null ? new HashMap<String, Object>(inputArguments) : new HashMap();
        arguments.put(MULE_CONTEXT, this.muleContext);
        arguments.put(MULE_EVENT, event);
        if (streaming) {
            return this.graphExecutor.executeStreaming(input, pipeSize, arguments, new OutputArgumentHandler(){

                @Override
                public void addArgument(String name, Object value) {
                    event.getMessage().setProperty(name, value, PropertyScope.INVOCATION);
                }
            });
        }
        TransformationResult result = this.graphExecutor.execute(input, arguments);
        Map<String, Object> otherResults = result.getOutputArguments();
        for (Map.Entry<String, Object> outputArgument : otherResults.entrySet()) {
            if (outputArgument.getValue() == null) continue;
            event.getMessage().setProperty(outputArgument.getKey(), outputArgument.getValue(), PropertyScope.INVOCATION);
        }
        return result.getPayload();
    }

    public void setTransformationGraphPath(String transformationGraphPath) {
        this.transformationGraphPath = transformationGraphPath;
    }

    public void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getOutputContentType() {
        if (this.outputContentType == null) {
            this.outputContentType = this.graphExecutor.getOutputContentType();
        }
        return this.outputContentType;
    }

    public String getOutputEncoding() {
        if (this.outputEncoding == null) {
            this.outputEncoding = this.graphExecutor.getOutputEncoding();
        }
        return this.outputEncoding;
    }
}

