/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.api;

import com.mulesoft.mule.module.datamapper.api.GraphExecutor;
import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;
import com.mulesoft.mule.module.datamapper.clover.SimpleCloverGraphExecutorFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.component.fileoperation.pool.ConnectionPool;

public class DataMapperHelper {
    private Log logger = LogFactory.getLog(DataMapperHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(InputStream mappingFile, Object payload, Map<String, Object> arguments) throws Exception {
        GraphExecutorFactory executorFactory = null;
        try {
            executorFactory = this.createGraphExecutorFactory();
            executorFactory.init();
            GraphExecutor graphExecutor = executorFactory.createGraphExecutor(mappingFile);
            Object object = graphExecutor.execute(payload, arguments).getPayload();
            return object;
        }
        finally {
            if (executorFactory != null) {
                executorFactory.dispose();
            }
            try {
                this.deleteLoggingThreads();
                ConnectionPool.getInstance().close();
            }
            catch (Throwable t) {
                this.logger.error((Object)"Un expected error", t);
            }
        }
    }

    private void deleteLoggingThreads() {
        String[] threadsToDelete = new String[]{"Mule.log.clogging.ref.handler", "Mule.log.slf4j.ref.handler"};
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        Thread[] threadArray = threadSet.toArray(new Thread[threadSet.size()]);
        for (String threadToDelete : threadsToDelete) {
            for (Thread t : threadArray) {
                if (!threadToDelete.equals(t.getName())) continue;
                try {
                    t.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    protected GraphExecutorFactory createGraphExecutorFactory() {
        return new SimpleCloverGraphExecutorFactoryImpl(UUID.randomUUID().toString(), new CloverEngineManager(CloverEngineConfig.createDefault(), new ConcurrentHashMap<String, CloverEngineImpl>()));
    }
}

