/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.mule.util.FileUtils;

public class CloverEngineConfig {
    public static final String CLOVER_PLUGINS = "clover-plugins";
    public static final String PATH_SEPARATOR = ";";
    private String cloverPluginDirPath;

    public String getCloverPluginDirPath() {
        return this.cloverPluginDirPath;
    }

    public void setCloverPluginDirPath(String cloverPluginDirPath) {
        this.cloverPluginDirPath = cloverPluginDirPath;
    }

    public static CloverEngineConfig createDefault() {
        CloverEngineConfig cloverEngineConfig = new CloverEngineConfig();
        ClassLoader cl = cloverEngineConfig.getClass().getClassLoader();
        Enumeration<URL> resource = null;
        try {
            resource = cl.getResources(CLOVER_PLUGINS);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resource == null || !resource.hasMoreElements()) {
            throw new RuntimeException("Data Mapper runtime is not installed on the mule runtime.");
        }
        try {
            String cloverPluginsPath = null;
            while (resource.hasMoreElements()) {
                URL plugin_url = resource.nextElement();
                String pluginPath = URLDecoder.decode(plugin_url.getFile(), FileUtils.DEFAULT_ENCODING);
                if (cloverPluginsPath == null) {
                    cloverPluginsPath = pluginPath;
                    continue;
                }
                cloverPluginsPath = cloverPluginsPath + PATH_SEPARATOR + pluginPath;
            }
            cloverEngineConfig.setCloverPluginDirPath(cloverPluginsPath);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return cloverEngineConfig;
    }
}

