/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.AbstractCloverGraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import com.mulesoft.mule.module.datamapper.clover.impl.GraphRuntimeContextFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.DocumentCloverGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.InputStreamCloverGraphFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CloverGraphPoolFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.PoolGraphProvider;
import com.mulesoft.mule.module.datamapper.util.DataMapperUtils;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.ExecutionType;
import org.mule.api.MuleContext;

public class CloverGraphExecutorFactory
extends AbstractCloverGraphExecutorFactory {
    private MuleContext muleContext;
    private static Log logger = LogFactory.getLog(CloverGraphExecutorFactory.class);
    private int initialPoolSize;

    public CloverGraphExecutorFactory(MuleContext muleContext, CloverEngineManager cloverEngineManager, int initialPoolSize) {
        super(cloverEngineManager);
        this.muleContext = muleContext;
        this.initialPoolSize = initialPoolSize;
    }

    @Override
    protected CloverEngineImpl getCloverEngine() {
        return this.getCloverEngineManager().getCloverEngine(this.muleContext);
    }

    @Override
    protected GraphProvider<TransformationGraph> createGraphProvider(CloverGraphFactory graphFactory) throws DataMapperCreationException {
        CloverGraphPoolFactory graphPoolFactory = new CloverGraphPoolFactory(graphFactory);
        PoolGraphProvider graphProvider = PoolGraphProvider.createGraphProvider(graphPoolFactory);
        graphProvider.initialize(this.initialPoolSize);
        return graphProvider;
    }

    @Override
    public void dispose() {
        this.getCloverEngineManager().dispose(this.muleContext);
    }

    @Override
    protected CloverGraphFactory createGraphFactory(String transformationGraphPath, ExecutionType executionType) {
        return new DocumentCloverGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType, this.muleContext.getExecutionClassLoader()), this.muleContext, DataMapperUtils.parseDocument(this.muleContext, transformationGraphPath));
    }

    @Override
    protected CloverGraphFactory createGraphFactory(InputStream inputStream, ExecutionType executionType) {
        return new InputStreamCloverGraphFactoryImpl(new GraphRuntimeContextFactoryImpl(executionType, this.muleContext.getExecutionClassLoader()), inputStream);
    }
}

