/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;
import com.mulesoft.mule.module.datamapper.api.TransformationEngine;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.MappingFormat;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverResult;
import com.mulesoft.mule.module.datamapper.clover.impl.DataMapperThreadManager;
import com.mulesoft.mule.module.datamapper.util.Counter;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.graph.Node;
import org.jetel.graph.Result;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.dictionary.Dictionary;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.jetel.graph.runtime.SingleThreadWatchDog;
import org.jetel.graph.runtime.WatchDog;

public class CloverEngineImpl
implements TransformationEngine<TransformationGraph> {
    private static Log log = LogFactory.getLog(CloverEngineImpl.class);
    public static final int DEFAULT_MAX_GRAPH = Integer.getInteger("com.mulesoft.datamapper.max_graph", 0);
    public static final int DEFAULT_MAX_NODES = Integer.getInteger("com.mulesoft.datamapper.max_nodes", 0);
    private long runs;
    private DataMapperThreadManager threadManager;
    private Counter graphCounter = new Counter();

    private CloverEngineImpl(DataMapperThreadManager threadManager) {
        this.threadManager = threadManager;
    }

    public CloverEngineImpl() {
        this(new DataMapperThreadManager(DEFAULT_MAX_GRAPH, DEFAULT_MAX_NODES));
    }

    public TransformationResult execute(TransformationGraph graph, GraphRuntimeContext context, Map<String, Object> inputArgument) throws DataMapperExecutionException {
        this.validateGraph(graph);
        Dictionary dictionary = graph.getDictionary();
        try {
            for (Map.Entry<String, Object> inArgumentEntry : inputArgument.entrySet()) {
                dictionary.setValue(inArgumentEntry.getKey(), inArgumentEntry.getValue());
            }
        }
        catch (ComponentNotReadyException e) {
            log.error((Object)"Exception while generating dictionary", (Throwable)e);
            throw new DataMapperExecutionException(e);
        }
        ClassLoader muleContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            SingleThreadWatchDog watchDog = new SingleThreadWatchDog(graph, context);
            watchDog.init();
            CloverResult cloverResult = new CloverResult(watchDog.call(), dictionary);
            cloverResult.setCauseException(watchDog.getCauseException());
            CloverResult cloverResult2 = cloverResult;
            return cloverResult2;
        }
        catch (Exception e) {
            throw new DataMapperExecutionException("Data Mapper execution failed.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(muleContextClassLoader);
        }
    }

    @Override
    public MappingFormat getOutputType(TransformationGraph graph) {
        Map nodes = graph.getNodes();
        Collection values = nodes.values();
        for (Node value : values) {
            MappingFormat[] mappingFormats;
            String type = value.getType();
            for (MappingFormat mappingFormat : mappingFormats = MappingFormat.values()) {
                if (!mappingFormat.getWriterType().equals(type)) continue;
                return mappingFormat;
            }
        }
        return null;
    }

    @Override
    public String getOutputEncoding(TransformationGraph graph) {
        Map nodes = graph.getNodes();
        Collection values = nodes.values();
        for (Node value : values) {
            MappingFormat[] mappingFormats;
            String type = value.getType();
            for (MappingFormat mappingFormat : mappingFormats = MappingFormat.values()) {
                if (!mappingFormat.getWriterType().equals(type)) continue;
                return mappingFormat.getEncoding(value);
            }
        }
        return null;
    }

    @Override
    public TransformationResult execute(TransformationGraph graph, Map<String, Object> inputArgument) throws DataMapperExecutionException {
        return this.execute(graph, graph.getRuntimeContext(), inputArgument);
    }

    public void executeLater(TransformationGraph graph, GraphRuntimeContext context, Map<String, Object> inputArgument, FutureCallback<TransformationResult> callback) throws DataMapperExecutionException {
        this.validateGraph(graph);
        Dictionary dictionary = graph.getDictionary();
        try {
            for (Map.Entry<String, Object> inArgumentEntry : inputArgument.entrySet()) {
                dictionary.setValue(inArgumentEntry.getKey(), inArgumentEntry.getValue());
            }
        }
        catch (ComponentNotReadyException e) {
            log.error((Object)"Exception while generating dictionary", (Throwable)e);
            throw new DataMapperExecutionException(e);
        }
        WatchDog watchDog = new WatchDog(graph, context);
        this.getThreadManager().initWatchDog(watchDog);
        context.setRunId(this.nextRunId());
        FutureCallbackProxy proxy = new FutureCallbackProxy(graph, callback);
        try {
            this.getThreadManager().executeWatchDog(watchDog, proxy);
            this.graphCounter.increment();
        }
        catch (RuntimeException e) {
            throw new DataMapperExecutionException(e);
        }
    }

    @Override
    public void executeLater(TransformationGraph graph, Map<String, Object> inputArgument, FutureCallback<TransformationResult> callback) throws DataMapperExecutionException {
        this.executeLater(graph, graph.getRuntimeContext(), inputArgument, callback);
    }

    private void validateGraph(TransformationGraph graph) throws DataMapperExecutionException {
        if (!graph.isInitialized()) {
            throw new DataMapperExecutionException("Graph is not initialized.");
        }
    }

    @Override
    public synchronized void dispose() {
        log.info((Object)"Stopping clover transformation graph engine.");
        this.getThreadManager().free();
        log.info((Object)("Waiting for " + this.graphCounter.getCount() + " graphs to finish execution."));
        try {
            this.graphCounter.await(0);
        }
        catch (Exception e) {
            log.warn((Object)"Interruted while waiting for grahs to finish.", (Throwable)e);
        }
        log.info((Object)("Aborting " + this.graphCounter.getCount() + " running graphs."));
        this.getThreadManager().freeNow();
        log.info((Object)"Stopped clover transformation graph engine.");
    }

    private synchronized long nextRunId() {
        return this.runs++;
    }

    public DataMapperThreadManager getThreadManager() {
        return this.threadManager;
    }

    private class FutureCallbackProxy
    implements FutureCallback<Result> {
        private final FutureCallback<TransformationResult>[] targets;
        private TransformationGraph graph;

        public FutureCallbackProxy(TransformationGraph graph, FutureCallback<TransformationResult> ... target) {
            this.targets = target;
            this.graph = graph;
        }

        private void release() {
            try {
                CloverEngineImpl.this.graphCounter.decrement();
            }
            catch (InterruptedException e) {
                log.warn((Object)"Failed to decrement running graph count.", (Throwable)e);
            }
        }

        @Override
        public void done(Result result) {
            this.release();
            for (FutureCallback<TransformationResult> target : this.targets) {
                target.done(new CloverResult(result, this.graph.getDictionary()));
            }
        }

        @Override
        public void failed(Throwable throwable) {
            this.release();
            for (FutureCallback<TransformationResult> target : this.targets) {
                target.failed(throwable);
            }
        }

        @Override
        public void cancelled() {
            this.release();
            for (FutureCallback<TransformationResult> target : this.targets) {
                target.cancelled();
            }
        }
    }
}

