/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.Status;
import com.mulesoft.mule.module.datamapper.api.TransformationResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetel.graph.Result;
import org.jetel.graph.dictionary.Dictionary;

public class CloverResult
implements TransformationResult {
    private Result result;
    private Map<String, Object> outputArguments;
    private Object payload;
    private Throwable causeException;

    public CloverResult(Result result, Dictionary dictionary) {
        this.result = result;
        this.outputArguments = new HashMap<String, Object>();
        this.loadDataFromDictionary(dictionary);
    }

    private void loadDataFromDictionary(Dictionary dictionary) {
        Set keys = dictionary.getKeys();
        for (String key : keys) {
            if (!dictionary.isOutput(key) || key.equals("outputPayload")) continue;
            this.outputArguments.put(key, dictionary.getValue(key));
        }
        Object value = dictionary.getValue("outputPayload");
        if (value instanceof List) {
            List resultList = (List)value;
            if (resultList.size() == 1) {
                this.payload = resultList.get(0);
            }
        } else {
            this.payload = value;
        }
    }

    @Override
    public Status getStatus() {
        Status status = Status.READY;
        switch (this.result) {
            case FINISHED_OK: {
                status = Status.OK;
                break;
            }
            case ERROR: {
                status = Status.ERROR;
                break;
            }
            case RUNNING: {
                status = Status.RUNNING;
                break;
            }
            case ABORTED: {
                status = Status.ABORTED;
                break;
            }
            case READY: {
                status = Status.READY;
            }
        }
        return status;
    }

    @Override
    public String getMessage() {
        return this.result.message();
    }

    @Override
    public Object getPayload() {
        return this.payload;
    }

    @Override
    public Map<String, Object> getOutputArguments() {
        return this.outputArguments;
    }

    public void setCauseException(Throwable causeException) {
        this.causeException = causeException;
    }

    @Override
    public Throwable getCauseException() {
        return this.causeException;
    }
}

