/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;
import com.mulesoft.mule.module.datamapper.clover.impl.NotifyingFutureTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.Result;
import org.jetel.graph.runtime.CloverFuture;
import org.jetel.graph.runtime.IThreadManager;
import org.jetel.graph.runtime.WatchDog;

public class DataMapperThreadManager
implements IThreadManager {
    private static Log logger = LogFactory.getLog(DataMapperThreadManager.class);
    private ThreadPoolExecutor watchdogExecutor;
    private ThreadPoolExecutor nodeExecutor;
    private int maxNodes = 0;
    private int runningNodes = 0;

    public DataMapperThreadManager(int maxGraphs, int maxNodes) {
        this.maxNodes = maxNodes;
        this.watchdogExecutor = maxGraphs <= 0 ? (ThreadPoolExecutor)Executors.newCachedThreadPool(new WatchdogThreadFactory()) : (ThreadPoolExecutor)Executors.newFixedThreadPool(maxGraphs, new WatchdogThreadFactory());
        this.nodeExecutor = maxNodes <= 0 ? (ThreadPoolExecutor)Executors.newCachedThreadPool(new NodeThreadFactory()) : (ThreadPoolExecutor)Executors.newFixedThreadPool(maxNodes, new NodeThreadFactory());
    }

    public synchronized void initWatchDog(WatchDog watchDog) {
        watchDog.setThreadManager((IThreadManager)this);
        watchDog.init();
    }

    public synchronized CloverFuture executeWatchDog(WatchDog watchDog) {
        return new CloverFutureImpl(watchDog, this.watchdogExecutor.submit(watchDog));
    }

    public synchronized void executeWatchDog(WatchDog watchDog, FutureCallback<Result> callback) {
        this.watchdogExecutor.submit(new NotifyingFutureTask<Result>((Callable<Result>)watchDog, callback));
    }

    public synchronized void executeNode(Runnable node) {
        this.nodeExecutor.execute(node);
        ++this.runningNodes;
    }

    public void execute(Runnable runnable) {
        throw new UnsupportedOperationException("Execute is not supported");
    }

    public <T> Future<T> execute(Runnable runnable, T result) {
        FutureTask<T> futureTask = new FutureTask<T>(runnable, result);
        Thread thread = new Thread(futureTask, runnable.getClass().getName());
        thread.setContextClassLoader(runnable.getClass().getClassLoader());
        thread.setPriority(1);
        thread.setDaemon(false);
        thread.start();
        return futureTask;
    }

    public <T> Future<T> execute(Callable<T> callable) {
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        Thread thread = new Thread(futureTask, callable.getClass().getName());
        thread.setContextClassLoader(callable.getClass().getClassLoader());
        thread.setPriority(1);
        thread.setDaemon(false);
        thread.start();
        return futureTask;
    }

    public synchronized int getFreeThreadsCount() {
        if (this.maxNodes > 0) {
            return this.maxNodes - this.runningNodes;
        }
        return Integer.MAX_VALUE;
    }

    public synchronized void releaseNodeThreads(int nodeThreadsToRelease) {
        this.runningNodes -= nodeThreadsToRelease;
    }

    public void free() {
        this.watchdogExecutor.shutdown();
        this.nodeExecutor.shutdown();
        logger.info((Object)"DataMapperThreadManager releasing resources");
    }

    public void freeNow() {
        this.watchdogExecutor.shutdownNow();
        this.nodeExecutor.shutdownNow();
        logger.info((Object)"DataMapperThreadManager releasing resources now");
    }

    private static class NodeThreadFactory
    implements ThreadFactory {
        private NodeThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Node");
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        }
    }

    private static class WatchdogThreadFactory
    implements ThreadFactory {
        private WatchdogThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DataMapperGraphWatchDog");
        }
    }

    private class CloverFutureImpl
    implements CloverFuture {
        private WatchDog watchDog;
        private Future<Result> future;

        public CloverFutureImpl(WatchDog watchDog, Future<Result> future) {
            this.watchDog = watchDog;
            this.future = future;
        }

        public WatchDog getWatchDog() {
            return this.watchDog;
        }

        public boolean cancel(boolean b) {
            return this.future.cancel(b);
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public boolean isDone() {
            return this.future.isDone();
        }

        public Result get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        public Result get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(l, timeUnit);
        }
    }
}

