/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl;

import com.mulesoft.mule.module.datamapper.api.FutureCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class NotifyingFutureTask<V>
extends FutureTask<V> {
    private final FutureCallback<V> callback;

    public NotifyingFutureTask(Callable<V> callable, FutureCallback<V> callback) {
        super(callable);
        this.callback = callback;
        if (callback == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
    }

    public NotifyingFutureTask(Runnable runnable, FutureCallback<V> callback) {
        super(runnable, null);
        this.callback = callback;
        if (callback == null) {
            throw new NullPointerException("Callback cannot be null.");
        }
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.callback.cancelled();
        } else {
            try {
                this.callback.done(this.get());
            }
            catch (CancellationException e) {
                this.callback.cancelled();
            }
            catch (ExecutionException e) {
                this.callback.failed(e.getCause());
            }
            catch (Exception e) {
                this.callback.failed(e);
            }
        }
    }
}

