/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.CloverGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;
import java.io.InputStream;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.TransformationGraphXMLReaderWriter;
import org.jetel.graph.dictionary.Dictionary;
import org.jetel.graph.runtime.EngineInitializer;
import org.jetel.graph.runtime.GraphRuntimeContext;

public abstract class AbstractGraphFactory
implements CloverGraphFactory {
    private GraphRuntimeContextFactory runtimeContextFactory;

    public AbstractGraphFactory(GraphRuntimeContextFactory runtimeContextFactory) {
        this.setRuntimeContextFactory(runtimeContextFactory);
    }

    protected TransformationGraph doCreateTransformationGraph(InputStream graphSourceStream, GraphRuntimeContext context) throws DataMapperCreationException {
        try {
            TransformationGraph graph = TransformationGraphXMLReaderWriter.loadGraph((InputStream)graphSourceStream, (GraphRuntimeContext)context);
            this.initGraph(context, graph);
            return graph;
        }
        catch (Exception e) {
            throw new DataMapperCreationException(e);
        }
    }

    protected void initGraph(GraphRuntimeContext context, TransformationGraph graph) throws ComponentNotReadyException {
        Dictionary dictionary = graph.getDictionary();
        dictionary.setValue("____@muleEvent@____", "object", null);
        dictionary.setAsInput("____@muleEvent@____");
        dictionary.setValue("____@muleContext@____", "object", null);
        dictionary.setAsInput("____@muleContext@____");
        EngineInitializer.initGraph((TransformationGraph)graph, (GraphRuntimeContext)context);
    }

    public TransformationGraph createTransformationGraph(InputStream graphSourceStream) throws DataMapperCreationException {
        GraphRuntimeContext graphRuntimeContext = this.getRuntimeContextFactory().createGraphRuntimeContext();
        return this.doCreateTransformationGraph(graphSourceStream, graphRuntimeContext);
    }

    public GraphRuntimeContextFactory getRuntimeContextFactory() {
        return this.runtimeContextFactory;
    }

    public void setRuntimeContextFactory(GraphRuntimeContextFactory runtimeContextFactory) {
        this.runtimeContextFactory = runtimeContextFactory;
    }
}

