/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.AbstractGraphFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.ClasspathCloverGraphFactoryImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.mule.api.MuleContext;

public class AppHomeCloverGraphFactoryImpl
extends AbstractGraphFactory {
    private static Log logger = LogFactory.getLog(AppHomeCloverGraphFactoryImpl.class);
    private final String graph;
    private MuleContext muleContext;

    public AppHomeCloverGraphFactoryImpl(String graph, MuleContext muleContext, GraphRuntimeContextFactory runtimeContextFactory) {
        super(runtimeContextFactory);
        this.graph = graph;
        this.muleContext = muleContext;
    }

    @Override
    public TransformationGraph createTransformationGraph() throws DataMapperCreationException {
        String appHome = (String)this.muleContext.getRegistry().get("app.home");
        File graphFile = new File(appHome, this.graph);
        if (!graphFile.exists()) {
            return new ClasspathCloverGraphFactoryImpl(this.getRuntimeContextFactory(), this.graph).createTransformationGraph();
        }
        GraphRuntimeContext graphRuntimeContext = this.getRuntimeContextFactory().createGraphRuntimeContext();
        FileInputStream fis = null;
        try {
            graphRuntimeContext.setContextURL(new File(appHome).toURI().toURL());
            fis = new FileInputStream(graphFile);
            TransformationGraph transformationGraph = this.doCreateTransformationGraph(fis, graphRuntimeContext);
            return transformationGraph;
        }
        catch (FileNotFoundException e) {
            throw new DataMapperCreationException(e);
        }
        catch (MalformedURLException e) {
            throw new DataMapperCreationException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Exception while closing stream");
            }
        }
    }
}

