/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphfactory;

import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.api.GraphRuntimeContextFactory;
import com.mulesoft.mule.module.datamapper.clover.impl.graphfactory.AbstractGraphFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetel.graph.TransformationGraph;
import org.jetel.graph.runtime.GraphRuntimeContext;
import org.mule.util.IOUtils;

public class ClasspathCloverGraphFactoryImpl
extends AbstractGraphFactory {
    private static Log logger = LogFactory.getLog(ClasspathCloverGraphFactoryImpl.class);
    private final String graph;

    public ClasspathCloverGraphFactoryImpl(GraphRuntimeContextFactory runtimeContextFactory, String graph) {
        super(runtimeContextFactory);
        this.graph = graph;
    }

    @Override
    public TransformationGraph createTransformationGraph() throws DataMapperCreationException {
        InputStream in = null;
        try {
            URL graphURL = IOUtils.getResourceAsUrl((String)this.graph, this.getClass());
            if (graphURL == null) {
                throw new DataMapperCreationException("The data mapping graph " + this.graph + " does not exists");
            }
            GraphRuntimeContext graphRuntimeContext = this.getRuntimeContextFactory().createGraphRuntimeContext();
            File file = new File(graphURL.getFile()).getParentFile();
            graphRuntimeContext.setContextURL(file.toURI().toURL());
            in = graphURL.openStream();
            TransformationGraph transformationGraph = this.doCreateTransformationGraph(in, graphRuntimeContext);
            return transformationGraph;
        }
        catch (IOException e) {
            logger.error((Object)"Unexpected error", (Throwable)e);
            throw new DataMapperCreationException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Unexpected error", (Throwable)e);
                }
            }
        }
    }
}

