/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.clover.impl.graphprovider;

import com.mulesoft.mule.module.datamapper.api.GraphProvider;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.graphprovider.CloverGraphPoolFactory;
import java.io.IOException;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jetel.graph.TransformationGraph;

public class PoolGraphProvider
implements GraphProvider<TransformationGraph> {
    public static final int DEFAULT_CACHE_SIZE = Integer.MAX_VALUE;
    private GenericObjectPool pool;

    public static PoolGraphProvider createGraphProvider(CloverGraphPoolFactory graphPoolFactory) {
        try {
            int defaultMaxGraph = CloverEngineImpl.DEFAULT_MAX_GRAPH <= 0 ? Integer.MAX_VALUE : CloverEngineImpl.DEFAULT_MAX_GRAPH;
            GenericObjectPool genericObjectPool = new GenericObjectPool((PoolableObjectFactory)graphPoolFactory, defaultMaxGraph);
            return new PoolGraphProvider(genericObjectPool);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PoolGraphProvider(GenericObjectPool pool) throws IOException, DataMapperCreationException {
        this.pool = pool;
    }

    public void initialize(int initialElements) {
        for (int i = 0; i < initialElements; ++i) {
            try {
                this.pool.addObject();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void releaseGraph(TransformationGraph transformationGraph) {
        if (transformationGraph == null) {
            return;
        }
        try {
            this.pool.returnObject((Object)transformationGraph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void invalidateObject(TransformationGraph transformationGraph) {
        if (transformationGraph == null) {
            return;
        }
        try {
            this.pool.invalidateObject((Object)transformationGraph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TransformationGraph takeGraph() {
        try {
            return (TransformationGraph)this.pool.borrowObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

